#include <stdio.h>

#define MAXN 200000

long long tmp[MAXN];
void merge_sort(long long *a, int n) {
    for (int len = 1; len < n; len *= 2) {
        for (int l = 0; l < n; l += 2*len) {
            int m = l + len;
            int r = l + 2*len;
            if (m > n) m = n;
            if (r > n) r = n;
            int i = l, j = m, k = l;
            while (i < m && j < r) {
                if (a[i] <= a[j]) tmp[k++] = a[i++];
                else tmp[k++] = a[j++];
            }
            while (i < m) tmp[k++] = a[i++];
            while (j < r) tmp[k++] = a[j++];
            for (i = l; i < r; i++) a[i] = tmp[i];
        }
    }
}
long long count_pairs(long long *a, int n) {
    long long res = 0;
    int i = 0;
    while (i < n) {
        int j = i;
        while (j < n && a[j] == a[i]) j++;
        long long k = j - i;
        res += k*(k-1)/2;
        i = j;
    }
    return res;
}

int main() {
    int n;
    scanf("%d", &n);
    long long x[MAXN], y[MAXN];
    long long A[MAXN], B[MAXN];

    for (int i = 0; i < n; i++) {
        scanf("%lld %lld", &x[i], &y[i]);
        A[i] = x[i] + y[i];
        B[i] = x[i] - y[i];
    }

    merge_sort(A, n);
    merge_sort(B, n);

    long long ans = count_pairs(A, n) + count_pairs(B, n);

    printf("%lld\n", ans*2);
    return 0;
}